function label = SCORE_update(A, r)
    % Algorithm parameters
    n = size(A, 1);  % Number of nodes

    % Create graph from adjacency matrix
    G = graph(A);
    components = conncomp(G); % Find connected components

    % Check connectivity
    if max(components) > 1
        fprintf('Graph is not connected. Processing largest connected component.\n');

        % Find the largest connected component
        [~, largest_comp] = max(histcounts(components));
        largest_nodes = find(components == largest_comp);

        % Subgraph for the largest connected component
        A_sub = A(largest_nodes, largest_nodes);
        n_sub = size(A_sub, 1);

        % Perform SCORE on the largest connected component
        [vb, db] = eigs(A_sub, r);
        vb2 = vb(:, 2:r);
        rb = vb2 ./ repmat(vb(:, 1), [1, r - 1]);
        sub_labels = kmeans(rb, r, 'Replicates', 200);

        % Initialize labels for all nodes
        label = zeros(n, 1);

        % Assign labels to the largest connected component
        label(largest_nodes) = sub_labels;

        % Randomly assign labels to nodes not in the largest connected component
        other_nodes = setdiff(1:n, largest_nodes);
        label(other_nodes) = randi([1, r], length(other_nodes), 1);
    else
        % Graph is connected; proceed normally
        [vb, db] = eigs(A, r);
        vb2 = vb(:, 2:r);
        rb = vb2 ./ repmat(vb(:, 1), [1, r - 1]);
        threshold = 2*log(n);
        rb(rb > threshold) = threshold;   % Truncate ratio
        rb(rb < -threshold) = -threshold;
        label = kmeans(rb, r, 'Replicates', 200);
    end
end